/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWDesignerValidationItem;
import filenet.vw.toolkit.design.message.images.VWImageLoader;
import filenet.vw.toolkit.design.message.resources.VWResource;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWValidationErrorListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_errorIcon = null;
    private ImageIcon m_warningIcon = null;

    public VWValidationErrorListCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_errorIcon = VWImageLoader.createImageIcon("error.gif");
            this.m_warningIcon = VWImageLoader.createImageIcon("warning.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null) {
            ImageIcon icon = null;
            String text = null;
            if (value instanceof VWValidationError) {
                VWValidationError error = (VWValidationError)value;
                text = error.getName();
                switch (error.getLevel()) {
                    case 1: {
                        icon = this.m_errorIcon;
                        break;
                    }
                    case 2: {
                        icon = this.m_warningIcon;
                    }
                }
            } else if (value instanceof VWDesignerValidationItem) {
                VWDesignerValidationItem validationItem = (VWDesignerValidationItem)value;
                text = validationItem.getName();
                switch (validationItem.getLevel()) {
                    case 1: {
                        icon = this.m_errorIcon;
                        break;
                    }
                    case 2: {
                        icon = this.m_warningIcon;
                    }
                }
            } else if (value instanceof String) {
                text = (String)value;
            }
            this.setIcon(icon);
            if (text == null || text.length() == 0) {
                text = VWResource.s_emptyName;
            }
            this.setText(text);
        } else {
            this.setText("<null value>");
            this.setToolTipText(null);
        }
        return this;
    }
}

